/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.gui.performance;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import me.shedaniel.clothconfig2.gui.widget.DynamicElementListWidget;
import me.shedaniel.clothconfig2.gui.widget.DynamicEntryListWidget;
import me.shedaniel.rei.RoughlyEnoughItemsCore;
import me.shedaniel.rei.api.common.plugins.REIPluginProvider;
import me.shedaniel.rei.impl.client.gui.performance.entry.PerformanceEntryImpl;
import me.shedaniel.rei.impl.client.gui.performance.entry.SubCategoryListEntry;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextColor;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.util.FormattedCharSequence;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class PerformanceScreen
extends Screen {
    private Screen parent;
    private PerformanceEntryListWidget list;

    public PerformanceScreen(Screen parent) {
        super((Component)new TranslatableComponent("text.rei.performance"));
        this.parent = parent;
    }

    public static FormattedCharSequence formatTime(long time, boolean total) {
        TimeUnit unit = PerformanceScreen.chooseUnit(time);
        double value = (double)time / (double)TimeUnit.NANOSECONDS.convert(1L, unit);
        return new TextComponent(String.format(Locale.ROOT, "%.4g", value) + " " + PerformanceScreen.abbreviate(unit)).m_130938_(style -> style.m_131148_(TextColor.m_131266_((int)PerformanceScreen.chooseColor(TimeUnit.MILLISECONDS.convert(time, TimeUnit.NANOSECONDS), total)))).m_7532_();
    }

    private static int chooseColor(long time, boolean total) {
        if (time > (long)(total ? 2500 : 1000)) {
            return 0xFF5555;
        }
        if (time > (long)(total ? 700 : 300)) {
            return 16754176;
        }
        if (time > (long)(total ? 200 : 100)) {
            return 16773143;
        }
        return 0x12FF22;
    }

    private static TimeUnit chooseUnit(long nanos) {
        if (TimeUnit.DAYS.convert(nanos, TimeUnit.NANOSECONDS) > 0L) {
            return TimeUnit.DAYS;
        }
        if (TimeUnit.HOURS.convert(nanos, TimeUnit.NANOSECONDS) > 0L) {
            return TimeUnit.HOURS;
        }
        if (TimeUnit.MINUTES.convert(nanos, TimeUnit.NANOSECONDS) > 0L) {
            return TimeUnit.MINUTES;
        }
        if (TimeUnit.SECONDS.convert(nanos, TimeUnit.NANOSECONDS) > 0L) {
            return TimeUnit.SECONDS;
        }
        if (TimeUnit.MILLISECONDS.convert(nanos, TimeUnit.NANOSECONDS) > 0L) {
            return TimeUnit.MILLISECONDS;
        }
        if (TimeUnit.MICROSECONDS.convert(nanos, TimeUnit.NANOSECONDS) > 0L) {
            return TimeUnit.MICROSECONDS;
        }
        return TimeUnit.NANOSECONDS;
    }

    private static String abbreviate(TimeUnit unit) {
        switch (unit) {
            case NANOSECONDS: {
                return "ns";
            }
            case MICROSECONDS: {
                return "\u03bcs";
            }
            case MILLISECONDS: {
                return "ms";
            }
            case SECONDS: {
                return "s";
            }
            case MINUTES: {
                return "min";
            }
            case HOURS: {
                return "h";
            }
            case DAYS: {
                return "d";
            }
        }
        throw new AssertionError();
    }

    public void m_7856_() {
        MutableComponent backText = new TextComponent("\u21a9 ").m_7220_((Component)new TranslatableComponent("gui.back"));
        this.m_142416_((GuiEventListener)new Button(4, 4, Minecraft.m_91087_().f_91062_.m_92852_((FormattedText)backText) + 10, 20, (Component)backText, button -> {
            this.f_96541_.m_91152_(this.parent);
            this.parent = null;
        }));
        this.list = new PerformanceEntryListWidget();
        long[] totalTime = new long[]{0L};
        RoughlyEnoughItemsCore.PERFORMANCE_LOGGER.getStages().forEach((stage, inner) -> {
            long separateTime;
            ArrayList<PerformanceEntry> entries = new ArrayList<PerformanceEntry>();
            inner.times().forEach((obj, time) -> entries.add(new PerformanceEntryImpl((Component)new TextComponent(obj instanceof Pair ? ((REIPluginProvider)((Pair)obj).getFirst()).getPluginProviderName() : Objects.toString(obj)), (long)time)));
            Collection<Long> values = inner.times().values();
            Map<Object, Long> map = inner.times();
            synchronized (map) {
                separateTime = values.stream().collect(Collectors.summarizingLong(value -> value)).getSum();
            }
            if (inner.totalNano() - separateTime > 1000000L) {
                entries.add(new PerformanceEntryImpl((Component)new TextComponent("Miscellaneous Operations"), inner.totalNano() - separateTime));
            }
            totalTime[0] = totalTime[0] + Math.max(inner.totalNano(), separateTime);
            entries.sort(Comparator.comparingLong(value -> value.time).reversed());
            this.list.addItem(new SubCategoryListEntry((Component)new TextComponent(stage), entries, Math.max(inner.totalNano(), separateTime), false));
        });
        this.list.m_6702_().add(0, new PerformanceEntryImpl((Component)new TextComponent("Total Load Time"), totalTime[0]));
        this.m_7787_((GuiEventListener)this.list);
    }

    public void m_6305_(PoseStack poses, int mouseX, int mouseY, float delta) {
        this.m_96626_(0);
        this.list.m_6305_(poses, mouseX, mouseY, delta);
        this.f_96547_.m_92744_(poses, this.f_96539_.m_7532_(), (float)this.f_96543_ / 2.0f - (float)this.f_96547_.m_92852_((FormattedText)this.f_96539_) / 2.0f, 12.0f, -1);
        super.m_6305_(poses, mouseX, mouseY, delta);
    }

    private class PerformanceEntryListWidget
    extends DynamicElementListWidget<PerformanceEntry> {
        public PerformanceEntryListWidget() {
            super(PerformanceScreen.this.f_96541_, PerformanceScreen.this.f_96543_, PerformanceScreen.this.f_96544_, 30, PerformanceScreen.this.f_96544_, GuiComponent.f_93096_);
        }

        public int getItemWidth() {
            return this.width;
        }

        public int addItem(PerformanceEntry item) {
            return super.addItem((DynamicEntryListWidget.Entry)item);
        }

        protected int getScrollbarPosition() {
            return this.width - 6;
        }
    }

    public static abstract class PerformanceEntry
    extends DynamicElementListWidget.ElementEntry<PerformanceEntry> {
    }
}

